#pragma once

const char index_html[] PROGMEM = R"rawliteral(
<!DOCTYPE html>
<html lang="de">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <title>Photosensor</title>
    <link rel="icon" href="data:,">
    <link rel="stylesheet" type="text/css" href="style.css">
    <script src="PlotStuff.js"></script>
</head>
<body>
    <header>
        <nav>
            <ul>
                <li><a href="index.html" class="open">Simple</a></li>
                <li><a href="Graph_I.html">Graph</a></li>
                <li><a href="infos.html">About</a></li>
            </ul>
        </nav>
    </header>
    <main class="Block">
        <div class="DataVis">
            <h1>O3Q Light Sensor</h1>
            <div class="plot" style="font-size: 0px;">
                <!-- Left Scale -->
                <svg id="ScaleLeft" width="25%" height="100%" style="margin:0">
                    <defs>
                        <linearGradient id="lgrad1" x1="0" y1="0" x2="1" y2="0">
                            <stop offset="0.8" stop-color="#FFF" />
                            <stop offset="1" stop-color="#BBB" />
                        </linearGradient>
                    </defs>
                    <rect id="DataRectl" x="0" y="100%" width="100%" height="0%" fill="url(#lgrad1)" />
                    <line x1="100%" x2="100%" y1="0" y2="100%" style="stroke:black;stroke-width:4"/>
                    <!-- Graduation marks for the left scale -->
                    <line x1="85%" x2="100%" y1="5%" y2="5%"style="stroke:black;stroke-width:2"/>
                    <text x="80%" y="5%" alignment-baseline="central" style='font-size:18px; text-anchor:end;'>100000lx</text>
                    <line x1="85%" x2="100%" y1="23%" y2="23%"style="stroke:black;stroke-width:2"/>
                    <text x="80%" y="23%" alignment-baseline="central" style='font-size:18px; text-anchor:end;'>10000lx</text>
                    <line x1="85%" x2="100%" y1="41%" y2="41%"style="stroke:black;stroke-width:2"/>
                    <text x="80%" y="41%" alignment-baseline="central" style='font-size:18px; text-anchor:end;'>1000lx</text>
                    <line x1="85%" x2="100%" y1="59%" y2="59%"style="stroke:black;stroke-width:2"/>
                    <text x="80%" y="59%" alignment-baseline="central" style='font-size:18px; text-anchor:end;'>100lx</text>
                    <line x1="85%" x2="100%" y1="77%" y2="77%"style="stroke:black;stroke-width:2"/>
                    <text x="80%" y="77%" alignment-baseline="central" style='font-size:18px; text-anchor:end;'>10lx</text>
                    <line x1="85%" x2="100%" y1="95%" y2="95%"style="stroke:black;stroke-width:2"/>
                    <text x="80%" y="95%" alignment-baseline="central" style='font-size:18px; text-anchor:end;'>1lx</text>
                </svg>
                <!-- Center Area -->
                <svg width="50%" height="100%" style="max-width:70rem;">
                    <rect id="DataRect" x="0" y="100%" width="100%" height="0%" fill="#BBB" />
                </svg>
                <!-- Right Scale -->
                <svg id="ScaleRight" width="25%" height="100%" style="margin:0">
                    <defs>
                        <linearGradient id="lgrad2" x1="0" y1="0" x2="1" y2="0">
                            <stop offset="0" stop-color="#BBB" />
                            <stop offset="0.2" stop-color="#FFF" />
                        </linearGradient>
                    </defs>
                    <rect id="DataRectr" x="0" y="100%" width="100%" height="0%" fill="url(#lgrad2)" />
                    <line x1="0%" x2="0%" y1="0" y2="100%" style="stroke:black;stroke-width:4"/>
                    <!-- Graduation marks for the right scale -->
                    <line x1="0%" x2="15%" y1="5%" y2="5%"style="stroke:black;stroke-width:2"/>
                    <text x="20%" y="5%" alignment-baseline="central" style='font-size:18px; text-anchor:start;'>100000lx</text>
                    <line x1="0%" x2="15%" y1="23%" y2="23%"style="stroke:black;stroke-width:2"/>
                    <text x="20%" y="23%" alignment-baseline="central" style='font-size:18px; text-anchor:start;'>10000lx</text>
                    <line x1="0%" x2="15%" y1="41%" y2="41%"style="stroke:black;stroke-width:2"/>
                    <text x="20%" y="41%" alignment-baseline="central" style='font-size:18px; text-anchor:start;'>1000lx</text>
                    <line x1="0%" x2="15%" y1="59%" y2="59%"style="stroke:black;stroke-width:2"/>
                    <text x="20%" y="59%" alignment-baseline="central" style='font-size:18px; text-anchor:start;'>100lx</text>
                    <line x1="0%" x2="15%" y1="77%" y2="77%"style="stroke:black;stroke-width:2"/>
                    <text x="20%" y="77%" alignment-baseline="central" style='font-size:18px; text-anchor:start;'>10lx</text>
                    <line x1="0%" x2="15%" y1="95%" y2="95%"style="stroke:black;stroke-width:2"/>
                    <text x="20%" y="95%" alignment-baseline="central" style='font-size:18px; text-anchor:start;'>1lx</text>
                </svg>
            </div>
        </div>
        <div class="DataVis" style="z-index: 2;height: 100vh;">
            <div id="lxvalue"; style="font-size: 10vw; font-weight:50 ;height: 100%; line-height: 100vh;  width: 100%; text-align: center">
                NULL
            </div>
        </div>
        <div class="grid-container" style="display: none;">
            <div class="grid gridplot" id="fullPlot">
            </div>
            <div class="grid gridplot2" style="font-size: 500%">
                <input type="text" id="Display" value=500 style="font-size: 20vw; font-weight:50 ;  width: 80vw; text-align: end; border: none; background-color:#00000000;" >
            </div>
        </div>
        <script>
            let n=3;
            async function reset_I() {
                YValue=await measureI();
                if(n==3){document.getElementById("lxvalue").innerHTML=YValue+"lx";n=1}else{n++;}
                movedataRect(YValue,document.getElementById("DataRect"))
                movedataRect(YValue,document.getElementById("DataRectl"))
                movedataRect(YValue,document.getElementById("DataRectr"))
            }

            function _measureI(){return new Promise(function(resolve){setTimeout(function(){resolve(parseInt(Math.floor(Math.random()*130000*1+130000*0)));},2)});}
            function measureI() {
                return new Promise(function(resolve) {
                    var xhr =new XMLHttpRequest();
                    xhr.onreadystatechange=function() {if (this.readyState==4 && this.status ==200){resolve(this.responseText);}}
                    xhr.open("GET", "/measure", true);
                    xhr.send();
                });
            }
            resetInterval = setInterval(reset_I, 200);
        </script>
    </main>
    <footer style="position: fixed; bottom:0; right:0; left:0; z-index: 2;">
        <p> University of Muenster -  Institute for Physics Education  - info@o3q.de</p>
    </footer>
</body>
</html>
)rawliteral";
/************************************************************************************************************************************************************************/
const char Graph_I_html[] PROGMEM = R"rawliteral(
<!DOCTYPE html>

<html lang="de">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <title>Photosensor</title>
    <link rel="icon" href="data:,">
    <link rel="stylesheet" type="text/css" href="style.css">
    <script src="PlotStuff.js"></script>
    <script src="Graph_I.js"></script>
</head>



<!----------------------Body---------------------->

<body>
    <header>
        <nav>
            <ul>
                <li><a href="index.html">Simple</a></li>
                <li><a href="Graph_I.html" class="open">Graph</a></li>
                <!--<li><a href="2ESPs.html">2ESPs</a></li>-->
                <li><a href="infos.html">About</a></li>
            </ul>
        </nav>
    </header>

    <div id="popupBackground" class="popupBackground" onmousedown="closeSettings()" ontouchstart="closeSettings()">
        <div id="popup" class="popup">
            <div class="Closebutton" onclick="document.getElementById('popupBackground').style.display='none'" >
                &#10006
            </div>
            <h2>Display Options </h2> 
            <div>
                <h3>Axis Labels:</h3>
                <article class="inputField">
                    <label for="XLabelInput">X-Axis:</label>
                    <input type="text" id="XLabelInput" value="No." maxlength="5"
                        onchange="labelAxis(DataPlot,this.value,document.getElementById('YLabelInput').value,DataTable)"; onfocus="document.getElementById('Sonderzeichen').style.display='block'; focusedInput=this;"  >
                    <label style="padding-left: 2em;" , for="YLabelInput">Y-Axis:</label>
                    <input type="text" id="YLabelInput" value="I/lx" maxlength="5"
                        onchange="labelAxis(DataPlot,document.getElementById('XLabelInput').value,this.value);" onfocus="document.getElementById('Sonderzeichen').style.display='block'; focusedInput=this;">
                </article>
                <article id="Sonderzeichen", style="display: none;">
                    Insert Special Character:<br/>
                    <input type="button" class="CharButton" value="&#945" onclick="addSpecChar(this)">
                    <input type="button" class="CharButton" value="&#946" onclick="addSpecChar(this)">
                    <input type="button" class="CharButton" value="&#947" onclick="addSpecChar(this)">
                    <input type="button" class="CharButton" value="&#948" onclick="addSpecChar(this)">
                    <input type="button" class="CharButton" value="&#952" onclick="addSpecChar(this)">
                    <input type="button" class="CharButton" value="&#956" onclick="addSpecChar(this)">
                    <input type="button" class="CharButton" value="&#960" onclick="addSpecChar(this)">
                    <input type="button" class="CharButton" value="&#966" onclick="addSpecChar(this)">
                    <input type="button" class="CharButton" value="°" onclick="addSpecChar(this)">
                    <input type="button" class="CharButton" value="/" onclick="addSpecChar(this)">
                    <input type="button" class="CharButton" value="#" onclick="addSpecChar(this)">


                </article>
            </div>
            <div onmousedown="document.getElementById('Sonderzeichen').style.display='none';">   
                <h3>X Range:</h3>
                <article class="inputField">
                    <label for="inputNxValues">Number of shown X Values:</label>
                    <input type="number" id="inputNxValues" value=50 min="10" max="250" style="width:3em" onchange="ensureMaxVals(this);AdaptXRange(this);"><br>
                        
                    <label for="inputdX">X Interval:</label>
                    <input type="number" id="inputdX" value=1 min="0.1" max="10" style="width:3em" onchange="dX=this.value;createAxisScales(DataPlot,DataPlot.maxValues)"><br>

                    <input type="checkbox" id="start_0" onclick="if(this.checked){aktuellerXwert--;XshiftDatapoints(-1);}else{aktuellerXwert++;XshiftDatapoints(+1)}"><label for="start_0"> Start at 0</label>

                    <br>
                </article><br>
                <h3>Behavior on X Overflow:</h3>
                <article class="inputField">
                    <input type="radio" id="bigger" name="overflow">
                    <label for="bigger">Expand Viewport</label><br>
                    <input type="radio" id="shift" checked="true" name="overflow">
                    <label for="shift">Pan Viewport</label>
                </article><br>
                <h3>Y-Range</h3>
                <article class="inputField">
                    <input type="radio" id="YAuto" name="Y-Scaling" checked="true" onchange="handleRadio()">
                    <label for="YAuto">Auto Fit to Values</label><br>
                    <input type="radio" id="YCustom"  name="Y-Scaling" onchange="handleRadio()">
                    <label for="YCustom">
                        From <input type="number" id="minY" value=0 min="0" max="95" style="width:4em" disabled onchange="handleYRange(this);">
                        to <input type="number" id="maxY" value=100 min="5" max="130000" style="width:4em" disabled onchange="handleYRange(this);">
                    </label>
                </article><br>
                <h3>Live Update</h3>
                <article class="inputField">
                    <input id="liveMeasurement" type="Checkbox" value="Restore" checked="true" onchange="movePoint.setAttribute('fill','#00000000');">
                    <label for="liveMeasurement"> Live Update Measurements</label>
                </article> <br>
                
                <h3>Restore Defaults</h3>
                <article class="inputField">
                    <input id="resetToDefault" type="button" class="Buttonlight" value="Restore" style="min-width:4rem; width: 8rem; height: 2.5rem;",
                    onclick="resetDefault();">
                </article>
            </div>
        </div>
    </div>

    <script>
    </script>
    <main class="Block">
        <h1>O3Q Light Sensor</h1>
        <div class="grid-container">
            <div class="gridback gb1"></div>
            <div class="gridback gb2"></div>
            <div class="grid gridplot" id="fullPlot" oncontextmenu="openSettings()">
            </div>
            <div class="gridback gc1">
                <input id="startMeasurement" type="button" class="Button" value="Record Measurement" onclick="SaveMeasurement(0);">
            </div>
            <div class="grid gc2">
                <input id="startMeasurementSeries" type="button" class="Button" value="Record Series" onclick="MeasurementSeries();">
            </div>
            <div class="grid gc3">
                <div class="inputField">
                    <label for="amount">Quantity:</label>
                    <input type="number" id="amount" value="10" min="2" max="100" onchange="ensureMaxVals(this);"> data points
                </div>
                <div class="inputField">
                    <label for="frequency">Messfrequenz:</label>
                    <input type="number" id="frequency" value="5" min="0.05" max="50" onchange="ensureMaxVals(this);">
                    Hz
                </div>
            </div>
            <div class="grid gc4">
                <input type="button" class="Buttonlight" value="Delete last data point" id="deleteLast" disabled
                    onclick="deleteLastPoint()">
            </div>
            <div class="grid gc5">
                <input type="button" class="Buttonlight" value="Delete all data points" id="deleteAll" disabled
                onclick="deleteAllPoints()">  
            </div>
            <div class="gridback gc6">
                <input type="button" class="Buttonlight" value="Display Options" , onclick="openSettings()">
            </div>
            <div class="gridback gc7">
                <input type="button" class="Buttonlight" value="Download Data" id="downloadcsv" disabled , onclick="DownloadCSV(DataPoints,[document.getElementById('XLabelInput').value,document.getElementById('YLabelInput').value,'Time'])">
            </div>
            <div class="grid gridTable">
                <details>
                    <summary>Recorded Measurements</summary>
                    <div id="table" style="padding: 0rem; margin: 0rem;"></div>
                </details>
            </div>
        </div>
        <script>
            // Create Plot:
            if (ScreenPortrait.matches) { DataPlot = createPlot(1, PortraitWidth, "fullPlot", [0, NxValues, 0, 50]); }
            else { DataPlot = createPlot(0.5, LandscapeWidth, "fullPlot", [0, NxValues, 0, 50]); }
            ScreenPortrait.addEventListener("change", adaptPlot);
            DataTable = createTable(["No.", "I", "Time"], "table");
            labelAxis(DataPlot, "No.", "I/lx", DataTable);
            movePoint=placedataPoint(1,50,DataPlot);
            // Messwerte aktualisieren: 
            resetInterval = setInterval(reset_I, 100, aktuellerXwert);
        </script>
    </main>

    <footer>
        <p> University of Muenster -  Institute for Physics Education  - info@o3q.de</p>
    </footer>

</body>

</html>
)rawliteral";
/************************************************************************************************************************************************************************/
const char Graph_I_js[] PROGMEM = R"rawliteral(
/************* Define Variables **********/
const PortraitWidth=1000;
const LandscapeWidth=1600;
var DataPoints=[];
var Scalepoints=[];
var MaxSavedValue=0;
var DataPlot;
var DataTable;
var aktuellerXwert=1;
var ScreenPortrait = window.matchMedia("(max-width: 850px)")
var NxValues=50;
var movePoint;
var focusedInput;
var dX=1;




/******** Measuring functions *************/


//DummyMessung
function _measureI(){return new Promise(function(resolve){setTimeout(function(){resolve(parseInt(Math.floor(Math.random()*10+45)));},1)});}

//Real Measurement
function measureI(){
    return new Promise(function(resolve){
        var xhr =new XMLHttpRequest();
        xhr.onreadystatechange=function() {if (this.readyState==4 && this.status ==200){resolve(this.responseText);}}
        xhr.open("GET", "/measure", true);
        xhr.send();
    });
}

// Live preview of Measurement
async function reset_I(){
    if(!document.getElementById("liveMeasurement").checked){return}
    YValue=await measureI();
    movedataPoint(aktuellerXwert,YValue,movePoint,DataPlot);
    
    if (Scalepoints.push(YValue)>10){Scalepoints.shift();}
    if(document.getElementById("YAuto").checked){autoscaleY(Scalepoints.concat([MaxSavedValue,2]),DataPlot);}
    else if(parseFloat(plot.maxValues[2]) > YValue || parseFloat(plot.maxValues[3]) < YValue) {
        console.log(plot.maxValues[2], plot.maxValues[3], YValue);
        alert("Automatische Anpassung des X-Bereichs aktiviert, weil die Messwerte sich außerhalb des eingestellten Bereichs befinden.")
        document.getElementById("YAuto").checked=true;
        handleRadio();
    }
}
// lock in one Measurement
async function SaveMeasurement(Series){
    let x=aktuellerXwert;
    aktuellerXwert++; 
    let y=await measureI();  
    newPoint=placedataPoint(x,y,DataPlot)
    DataPoints.push(newPoint);
    //Point=DataPoints[DataPoints.length];  
    MaxSavedValue=Math.max(MaxSavedValue,y);
    if (x+1>plot.maxValues[1]){
        if(document.getElementById("bigger").checked && DataPlot.maxValues[1]-DataPlot.maxValues[0]<=250){
            rescale(DataPlot,[plot.maxValues[0],plot.maxValues[1]+1,plot.maxValues[2],plot.maxValues[3]]);
        }        
        if(document.getElementById("shift").checked){
            rescale(DataPlot,[plot.maxValues[0]+1,plot.maxValues[1]+1,plot.maxValues[2],plot.maxValues[3]]);
        }
    }  
    addTableRow([parseFloat((x*dX).toPrecision(5)),y,newPoint.TimeStamp ],newPoint,DataTable);
    document.getElementById("inputNxValues").value=DataPlot.maxValues[1]-DataPlot.maxValues[0];
    if(!Series){        
        document.getElementById("deleteLast").disabled=false;
        document.getElementById("deleteAll").disabled=false;
        document.getElementById("downloadcsv").disabled=false;
    }
    }
// lock in several Measurements
function MeasurementSeries(){
    document.getElementById("startMeasurement").disabled=true;
    document.getElementById("startMeasurementSeries").disabled=true;
    document.getElementById("deleteAll").disabled=true;
    document.getElementById("deleteLast").disabled=true;
    document.getElementById("downloadcsv").disabled=true;
    var n = document.getElementById("amount").value;
    var f = document.getElementById("frequency").value;
    for (let i=0;i<n;i++){
        setTimeout(function(){SaveMeasurement(1);reset_I();},i*1000/f);
    }
    setTimeout(function(){
        document.getElementById("startMeasurement").disabled=false;
        document.getElementById("startMeasurementSeries").disabled=false;
        document.getElementById("deleteAll").disabled=false;
        document.getElementById("deleteLast").disabled=false;
        document.getElementById("downloadcsv").disabled=false;
    },n*1000/f);
}


//Open and Close Settings
function closeSettings(){
    if(event.target.id=="popupBackground"){document.getElementById("popupBackground").style.display="none"; document.getElementById('Sonderzeichen').style.display='none'}
}
function openSettings(){
    document.getElementById("popupBackground").style.display="block";
}
function addSpecChar(button){
    focusedInput.value+=button.value;
    focusedInput.focus();
}



/*******handle plot *********/

// Change plotsize to partrait/landscape setting
function adaptPlot() {
     if (ScreenPortrait.matches) { // If media query matches
         resizePlot(DataPlot,1,PortraitWidth);
     } else {
         resizePlot(DataPlot,0.5,LandscapeWidth);
     }
}

// Change X-range of Plot
function AdaptXRange(input){
    let maxValues=plot.maxValues;
    let xRange=parseInt(input.value);
    let xMin=Math.max(0,aktuellerXwert-xRange);
    let xMax=xMin+xRange;
    maxValues[0]=xMin;
    maxValues[1]=xMax;
    rescale(DataPlot,maxValues);
}

function deleteLastPoint(){
    let deletePoint=DataPoints.pop();
    DataPlot.removeChild(deletePoint);
    aktuellerXwert--; 
    if(!DataPoints.length){
        document.getElementById("deleteLast").disabled=true;
        document.getElementById("deleteAll").disabled=true;
        document.getElementById("downloadcsv").disabled=true;
    }
    DataTable.tBodies[0].removeChild(deletePoint.TableEntry);
    MaxSavedValue=0;
    DataPoints.forEach((element)=>MaxSavedValue=Math.max(MaxSavedValue,element.yVal));
    let Xrange=document.getElementById("inputNxValues").value;
    let XMax=Math.max(DataPoints.length+1,Xrange);    
    if(Xrange>50){
        rescale(DataPlot,[plot.maxValues[0],plot.maxValues[0]+Xrange-1,plot.maxValues[2],plot.maxValues[3]]);
        document.getElementById("inputNxValues").value=Xrange-1;
    } else{
        rescale(DataPlot,[XMax-Xrange,XMax,plot.maxValues[2],plot.maxValues[3]]);
    }

}

function deleteAllPoints(){
    while (DataPoints.length){deleteLastPoint();}
}




function XshiftDatapoints(distance){
    for(let i=0;i<DataPoints.length;i++){
        point=DataPoints[i];
        movedataPoint(point.xVal+distance,point.yVal,point,DataPlot);
    }
}

function handleRadio(){
    var minYinput=document.getElementById("minY");
    var maxYinput=document.getElementById("maxY");
    var Disabled=!document.getElementById("YCustom").checked
    minY.disabled=Disabled;
    maxY.disabled=Disabled;
    if (!Disabled){
        minYinput.value=DataPlot.maxValues[2];
        maxYinput.value=Math.round(DataPlot.maxValues[3]+2);
    }
}
function handleYRange(_this){
    ensureMaxVals(_this);
    var minYinput=document.getElementById("minY");
    var maxYinput=document.getElementById("maxY");
    rescale(DataPlot, [DataPlot.maxValues[0],DataPlot.maxValues[1],minYinput.value,maxYinput.value]);
    minYinput.max=maxYinput.value-5;
    maxYinput.min=parseFloat(minYinput.value)+5;
}

function resetDefault(){
    document.getElementById("XLabelInput").value="No.";
    document.getElementById("YLabelInput").value="I/lx";
    labelAxis(DataPlot,"No.","I/lx",DataTable);
    document.getElementById("inputNxValues").value="50";
    AdaptXRange(document.getElementById('inputNxValues'));
    document.getElementById("inputdX").value="1";
    dX=1;
    createAxisScales(DataPlot,DataPlot.maxValues);
    document.getElementById("shift").checked="1";
    document.getElementById("YAuto").checked="1";
    handleRadio();
    document.getElementById("liveMeasurement").checked="1";
    if(document.getElementById("start_0").checked){
        document.getElementById("start_0").checked=0;
        aktuellerXwert++;XshiftDatapoints(1);
    }
}



// Helperfunction to ensure, that ionput Values dont exceed the min- and max-values
function ensureMaxVals(input){
    var maxV=input.max;
    var minV=input.min;
    let Val=input.value;
    Val=Math.max(Val,minV);
    Val=Math.min(Val,maxV);
    input.value=Val;
    
}

)rawliteral";
/************************************************************************************************************************************************************************/
const char infos_html[] PROGMEM = R"rawliteral(
<!DOCTYPE HTML>
<html lang="de">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <title>NV Experimente</title>
    <link rel="icon" href="data:,">
    <link rel="stylesheet" type="text/css" href="style.css">
</head>
<body>
    <header>
        <nav>
            <ul>
                <li><a href="index.html">Start</a></li>
                <li><a href="Graph_I.html">Graph</a></li>
                <!--<li><a href="2ESPs.html">2ESPs</a></li>-->
                <li><a href="infos.html" class="open">About</a></li>
            </ul>
        </nav>
        <h1>O3Q Light Sensor</h1>
    </header>
    <main>        
        <article>
            <h2>More Information under <a href="https://www.O3Q.de">O3Q.de</a></h2>
        </article>
    </main>
    <footer style="position: fixed; bottom:0; right:0; left:0; z-index: 2;">
        <p> University of Muenster -  Institute for Physics Education  - info@o3q.de</p>
    </footer>
</body>
</html>

)rawliteral";
/************************************************************************************************************************************************************************/
const char PlotStuff_js[] PROGMEM = R"rawliteral(
const ns = "http://www.w3.org/2000/svg";
var CircSize = "5";
const drawingColor = "#333";

//Von Außen zu verwenden.

/* Generate a Plot in SVG with given Values: 
    Ratio: Ratio between Width and Height -> Select depending on Screensize
    Width: should be around 1000. Has an impact on the displayed text size and line width - Bigger Width-> smaller Lines
    parent: ID of parent element
    _maxvalues: [minimaler X-Wert, maximaler X-Wert, minimaler -Wert, maximaler Y-Wert,]
    The SVG gets some Attributes, that are used in other functions: 
         



*/

/**************** Generate a Plot *************/

//Generate a Plot in SVG with given Values: 
function createPlot(Ratio, Width, parentID, _maxValues) {//Ratio: Ratio between Width and Height -> Select depending on Screensize| Width: should be around 1000. Has an impact on the displayed text size and line width - Bigger Width-> smaller Lines| parent: ID of parent element| _maxvalues: [minimaler X-Wert, maximaler X-Wert, minimaler -Wert, maximaler Y-Wert,]  
    var plot = createSVG(Ratio, Width, parentID); // Creates SVG_Element
    plot.maxValues = _maxValues;                // 
    plot.Ratio = Ratio;                         // 
    plot.xFactor = plot.Width / (_maxValues[1] - _maxValues[0]); //Scaling-Factor
    plot.yFactor = plot.Height / (_maxValues[3] - _maxValues[2]);//Scaling-Factor
    plot.AxisGroup = plot.appendChild(document.createElementNS(ns, "g"));
    plot.ScaleGroup = plot.appendChild(document.createElementNS(ns, "g"));
    plot.DataPoints = [];
    createAxes(plot); //Hier werden X- und Y-Achse erzeugt.
    createAxisScales(plot, [0, 1, 0, 1]);
    document.getElementById(parentID).addEventListener('contextmenu', event => event.preventDefault());
    return plot;
}

//Create X- and Y-Axis for the Plot
function createAxes(plot) {
    plot.removeChild(plot.AxisGroup);
    plot.AxisGroup = plot.appendChild(document.createElementNS(ns, "g"));
    var XAxis = document.createElementNS(ns, "line");
    plot.AxisGroup.appendChild(XAxis);
    setAttrs(XAxis, {
        x1: "0",
        x2: plot.Width,
        y1: "0",
        y2: "0",
        stroke: drawingColor,
        "stroke-width": "3"
    });
    var XAxisArrow = document.createElementNS(ns, "polyline");
    plot.AxisGroup.appendChild(XAxisArrow);
    setAttrs(XAxisArrow, {
        points: (plot.Width - 20) + ",-10 " + plot.Width + ",0 " + (plot.Width - 20) + ",+10",
        fill: "none",
        stroke: drawingColor,
        "stroke-width": "3"
    });
    var YAxis = document.createElementNS(ns, "line");
    plot.AxisGroup.appendChild(YAxis);
    setAttrs(YAxis, {
        x1: "0",
        x2: "0",
        y1: "0",
        y2: plot.Height,
        stroke: drawingColor,
        "stroke-width": "3"
    });
    var YAxisArrow = document.createElementNS(ns, "polyline");
    plot.AxisGroup.appendChild(YAxisArrow);
    setAttrs(YAxisArrow, {
        points: "-10," + (plot.Height + 20) + " 0," + plot.Height + " 10," + (plot.Height + 20),
        fill: "none",
        stroke: drawingColor,
        "stroke-width": "3"
    });
}
function createYAxis(plot) {
    plot.removeChild(plot.AxisGroup);
    plot.AxisGroup = plot.appendChild(document.createElementNS(ns, "g"));
    var XAxis = document.createElementNS(ns, "line");
    var YAxis = document.createElementNS(ns, "line");
    plot.AxisGroup.appendChild(YAxis);
    setAttrs(YAxis, {
        x1: "0",
        x2: "0",
        y1: "0",
        y2: plot.Height,
        stroke: drawingColor,
        "stroke-width": "3"
    });
    var YAxisArrow = document.createElementNS(ns, "polyline");
    plot.AxisGroup.appendChild(YAxisArrow);
    setAttrs(YAxisArrow, {
        points: "-10," + (plot.Height + 20) + " 0," + plot.Height + " 10," + (plot.Height + 20),
        fill: "none",
        stroke: drawingColor,
        "stroke-width": "3"
    });
}
//Create Scales for the Axis
function createAxisScales(plot, oldMax) {
    plot.removeChild(plot.ScaleGroup);
    plot.ScaleGroup = plot.appendChild(document.createElementNS(ns, "g"));

    var XScale = getScalesteps(plot.maxValues[0], plot.maxValues[1], parseInt(Math.floor(plot.Width / 100)));
    for (let i = XScale[1]; i < plot.maxValues[1] * 0.95 + plot.maxValues[0] * 0.05; i += XScale[0]) {
        // Linie erzeugen
        var lineX = scaleToSVG([i, 0], oldMax)[0];
        var line = document.createElementNS(ns, "line");
        plot.ScaleGroup.appendChild(line);
        setAttrs(line, { x1: lineX, x2: lineX, y1: "0", y2: "20", stroke: drawingColor, "stroke-width": "3" });
        // Beschriftung erzeugen
        var Label = document.createElementNS(ns, "text");
        plot.ScaleGroup.appendChild(Label);
        Label.textContent = parseFloat((i*dX).toPrecision(5));
        setAttrs(Label, { x: lineX, y: "25", "text-anchor": "middle", "alignment-baseline": "hanging", style: "font:  25px Calibri", fill: drawingColor });

        lineX = scaleToSVG([i, 0], plot.maxValues)[0];
        // Animation x1
        var animx1 = document.createElementNS(ns, "animate");
        setAttrs(animx1, { attributeName: "x1", begin: "indefinite", dur: "0.05", to: lineX, fill: "freeze" });
        // Animation x2
        var animx2 = document.createElementNS(ns, "animate");
        setAttrs(animx2, { attributeName: "x2", begin: "indefinite", dur: "0.05", to: lineX, fill: "freeze" });
        // Animation Text
        var animLabel = document.createElementNS(ns, "animate");
        setAttrs(animLabel, { attributeName: "x", begin: "indefinite", dur: "0.05", to: lineX, fill: "freeze" });
        //Animationen starten
        line.appendChild(animx1);
        line.appendChild(animx2);
        Label.appendChild(animLabel);
        animx1.beginElement();
        animx2.beginElement();
        animLabel.beginElement();
    }
    

    var YScale = getScalesteps(plot.maxValues[2], plot.maxValues[3], parseInt(Math.floor(plot.Ratio * 30)));
    for (let i = YScale[1]; i < plot.maxValues[3] * 0.92 + plot.maxValues[2] * 0.08; i += YScale[0]) {

        //Linie erzeugen
        var lineY = scaleToSVG([0, i], oldMax)[1];
        var line = document.createElementNS(ns, "line");
        plot.ScaleGroup.appendChild(line);
        setAttrs(line, { x1: "0", x2: "-20", y1: lineY, y2: lineY, stroke: drawingColor, "stroke-width": "3" });
        // Beschriftung erzeugen
        var Label = document.createElementNS(ns, "text");
        plot.ScaleGroup.appendChild(Label);
        Label.textContent = parseFloat(i.toPrecision(5));
        setAttrs(Label, { x: "-25", y: lineY, "text-anchor": "end", "alignment-baseline": "central", style: "font:  25px Calibri", fill: drawingColor });

        lineY = scaleToSVG([0, i], plot.maxValues)[1];
        // Animation y1
        var animy1 = document.createElementNS(ns, "animate");
        setAttrs(animy1, { attributeName: "y1", begin: "indefinite", dur: "0.05", to: lineY, fill: "freeze" });
        // Animation y1
        var animy2 = document.createElementNS(ns, "animate");
        setAttrs(animy2, { attributeName: "y2", begin: "indefinite", dur: "0.05", to: lineY, fill: "freeze" });
        // Animation Text
        var animLabel = document.createElementNS(ns, "animate");
        setAttrs(animLabel, { attributeName: "y", begin: "indefinite", dur: "0.05", to: lineY, fill: "freeze" });
        // Animationen starten
        line.appendChild(animy1);
        line.appendChild(animy2);
        Label.appendChild(animLabel);
        animy1.beginElement();
        animy2.beginElement();
        animLabel.beginElement();
    }
}
function createYAxisScale(plot, oldMax) {
    plot.removeChild(plot.ScaleGroup);
    plot.ScaleGroup = plot.appendChild(document.createElementNS(ns, "g"));

    var YScale = getScalesteps(plot.maxValues[2], plot.maxValues[3], parseInt(Math.floor(plot.Ratio * 4)));
    for (let i = YScale[1]; i < plot.maxValues[3] * 0.92 + plot.maxValues[2] * 0.08; i += YScale[0]) {

        //Linie erzeugen
        var lineY = scaleToSVG([0, i], oldMax)[1];
        var line = document.createElementNS(ns, "line");
        plot.ScaleGroup.appendChild(line);
        setAttrs(line, { x1: "0", x2: "-20", y1: lineY, y2: lineY, stroke: drawingColor, "stroke-width": "3" });
        // Beschriftung erzeugen
        var Label = document.createElementNS(ns, "text");
        plot.ScaleGroup.appendChild(Label);
        Label.textContent = parseFloat(Math.pow(10,i).toPrecision(2));
        setAttrs(Label, { x: "-25", y: lineY, "text-anchor": "end", "alignment-baseline": "central", style: "font:  25px Calibri", fill: drawingColor });

        lineY = scaleToSVG([0, i], plot.maxValues)[1];
        // Animation y1
        var animy1 = document.createElementNS(ns, "animate");
        setAttrs(animy1, { attributeName: "y1", begin: "indefinite", dur: "0.05", to: lineY, fill: "freeze" });
        // Animation y1
        var animy2 = document.createElementNS(ns, "animate");
        setAttrs(animy2, { attributeName: "y2", begin: "indefinite", dur: "0.05", to: lineY, fill: "freeze" });
        // Animation Text
        var animLabel = document.createElementNS(ns, "animate");
        setAttrs(animLabel, { attributeName: "y", begin: "indefinite", dur: "0.05", to: lineY, fill: "freeze" });
        // Animationen starten
        line.appendChild(animy1);
        line.appendChild(animy2);
        Label.appendChild(animLabel);
        animy1.beginElement();
        animy2.beginElement();
        animLabel.beginElement();
    }
}
//Label X-Axis and Y-Axis
function labelAxis(plot, xLabel, yLabel, table) {
    if (!!plot.XLabel) {
        plot.removeChild(plot.XLabel);
    }
    plot.XLabel = document.createElementNS(ns, "text");
    setAttrs(plot.XLabel, {
        x: plot.Width,
        y: "40",
        "text-anchor": "end",
        "alignment-baseline": "central",
        style: "font:  35px Cambria",
        fill: drawingColor,
    });
    plot.XLabel.textContent = xLabel;
    plot.appendChild(plot.XLabel);
    if (!!plot.YLabel) {
        plot.removeChild(plot.YLabel);
    }
    plot.YLabel = document.createElementNS(ns, "text");
    setAttrs(plot.YLabel, {
        x: (plot.Height * -1),
        y: "-40",
        "text-anchor": "end",
        "alignment-baseline": "central",
        transform: "rotate(270)",
        style: "font:  35px Cambria",
        fill: drawingColor,
    });
    plot.YLabel.textContent = yLabel;
    plot.appendChild(plot.YLabel);
    // Tabellenheader auch benennen. 
    if(table){
        table.tHead.rows[0].cells[0].innerHTML=xLabel;
        table.tHead.rows[0].cells[0].innerHTML=xLabel;
    }


}


/************ Modify Plot *************/

//Resize Plot for adjusting to different Screensizes
function resizePlot(plot, Ratio, Width) {
    plot.Width = Width;
    plot.Ratio = Ratio;
    plot.Height = parseInt(Math.floor(plot.Width * Ratio) * -1);
    var PlotViewBox = "-100 " + (plot.Height - 50) + " " + (plot.Width + 200) + " " + ((plot.Height * -1) + 150);
    setAttrs(plot, {
        viewBox: PlotViewBox,
    });
    rescale(plot, plot.maxValues);
    createAxes(plot);
    plot.YLabel.setAttribute("x", (plot.Height * -1)); // Hier bei beiden X-Coordinate, weil YLabel um (0,0) gedreht ist! 
    plot.XLabel.setAttribute("x", (plot.Width));
}
//scale the Y-Axis according to currently shown points
function autoscaleY(DataPoints, plot) {
    var max = plot.maxValues[3];
    max = Math.max(...DataPoints);
    max += (max - plot.maxValues[2]) * 0.2
    if (plot.maxValues[3] != max) {
        plot.maxValues[3] = max;
        plot.maxValues[2] =0;
        rescale(plot, plot.maxValues);
    }
}
//Adjust to new maxvalues
function rescale(plot, _maxValues) {
    oldmaxValues = plot.maxValues
    plot.maxValues = _maxValues;
    plot.xFactor = plot.Width / (_maxValues[1] - _maxValues[0]);
    plot.yFactor = plot.Height / (_maxValues[3] - _maxValues[2]);
    for (let i = 0; i < plot.DataPoints.length; i++) {
        let point = plot.DataPoints[i];
        movedataPoint(point.xVal, point.yVal, point, plot);
    }
    createAxisScales(plot, oldmaxValues);
}



/**************** Generate a Table *************/

function createTable(columns, parent) {
    var table = document.createElement('table');
    tableHead = document.createElement('thead');
    tableBody = document.createElement('tbody');
    Headrow = document.createElement('tr');
    columns.forEach((item) => {
        var headcell = document.createElement('th');
        headcell.appendChild(document.createTextNode(item));
        Headrow.appendChild(headcell);
    })
    tableHead.appendChild(Headrow);
    table.appendChild(tableHead);
    table.appendChild(tableBody);
    document.getElementById(parent).appendChild(table);
    return table;
}

function addTableRow(columns, point, table) {
    point.TableEntry = document.createElement('tr');
    table.tBodies[0].appendChild(point.TableEntry);
    columns.forEach((item) => {
        var cell = document.createElement('td');
        cell.appendChild(document.createTextNode(item));
        point.TableEntry.appendChild(cell);
    })
    /*point.TableEntry.addEventListener("ondblclick", function () { focusPoint(point); })*/
    point.TableEntry.addEventListener("click", function () { switchFocus(point); })
    document.getElementById("inputdX").addEventListener("change", function(){point.TableEntry.cells[0].innerHTML=parseFloat((point.xVal*dX).toPrecision(5))})
    document.getElementById("start_0").addEventListener("change", function(){point.TableEntry.cells[0].innerHTML=parseFloat((point.xVal*dX).toPrecision(5))})
}
function addTableDoubleRow(columns, point1 ,point2, table) {
    point1.TableEntry = document.createElement('tr');
    table.tBodies[0].appendChild(point1.TableEntry);
    columns.forEach((item) => {
        var cell = document.createElement('td');
        cell.appendChild(document.createTextNode(item));
        point1.TableEntry.appendChild(cell);
    })
    /*point.TableEntry.addEventListener("ondblclick", function () { focusPoint(point); })*/
    point1.TableEntry.addEventListener("click", function () { switchFocus(point1); })
    point1.TableEntry.addEventListener("click", function () { switchFocus(point2); })
    document.getElementById("inputdX").addEventListener("change", function(){point.TableEntry.cells[0].innerHTML=parseFloat((point1.xVal*dX).toPrecision(5))})
    document.getElementById("start_0").addEventListener("change", function(){point.TableEntry.cells[0].innerHTML=parseFloat((point1.xVal*dX).toPrecision(5))})
}


/************ Place and Move Datapoints ********/

//Place new Point
function placedataPoint(x, y, plot) {
    var point = document.createElementNS(ns, "circle");
    point.focused = 0;
    point.xVal = x;
    point.yVal = y;
    var d = new Date();
    point.TimeStamp= d.getHours()+":"+d.getMinutes()+":"+d.getSeconds();
    var SVGCoordinates = scaleToSVG([x, y], plot.maxValues);
    setAttrs(point, {
        cx: SVGCoordinates[0],
        cy: SVGCoordinates[1],
        r: CircSize,
        fill: drawingColor,
        "stroke-width":0,
    });
    if (plot.maxValues[0] > x || plot.maxValues[1] < x|| plot.maxValues[2] > y || plot.maxValues[3] < y) {
        setAttrs(point, {
            fill: "#00000000",
        });
    }
    plot.appendChild(point);
    point.addEventListener("mouseover", function () { showCoordinates(point); })
    point.addEventListener("mouseleave", function () { hideCoordinates(point); })
    point.addEventListener("click", function () { switchFocus(point); })
    plot.DataPoints.push(point);
    return (point);
}
function placedataRect(y, plot) {
    var bar = document.createElementNS(ns, "rect");
    bar.yVal = y;
    var SVGCoordinates = scaleToSVG([0, y], plot.maxValues);
    setAttrs(bar, {
        x: SVGCoordinates[0],
        y: SVGCoordinates[1],
        width: 100,
        height: SVGCoordinates[1]*(-1),
        fill: "#888",
        "stroke-width":0,
        rx:10,
        ry:10,
    });
    plot.appendChild(bar);
    createYAxis(plot);
    return (bar);
}
//Move a data Point to a new position. Used for scaling and refreshing Point coordinates
function movedataPoint(x, y, point, plot) {
    point.xVal = x;
    point.yVal = y;
    var animX = document.createElementNS(ns, "animate");
    var animY = document.createElementNS(ns, "animate");
    var SVGCoordinates = scaleToSVG([x, y], plot.maxValues);
    if (plot.maxValues[0] > x || plot.maxValues[1] < x || parseFloat(plot.maxValues[2]) > y || parseFloat(plot.maxValues[3]) < y) {
        setAttrs(point, {
            fill: "#00000000",
        });
    }
    else {

        setAttrs(point, {
            fill: drawingColor,
        });
    }
    setAttrs(animX, {
        attributeName: "cx",
        begin: "indefinite",
        dur: "0.05",
        to: SVGCoordinates[0],
        fill: "freeze"
    });
    setAttrs(animY, {
        attributeName: "cy",
        begin: "indefinite",
        dur: "0.05",
        to: SVGCoordinates[1],
        fill: "freeze"
    });
    point.appendChild(animX);
    point.appendChild(animY);
    animX.beginElement();
    animY.beginElement();
    return point
}
function movedataRect(y, bar, plot) {
    bar.yVal = y;
    var animY= document.createElementNS(ns, "animate");
    var animHeight = document.createElementNS(ns, "animate");
    var SVGCoordinates = scaleToSVG([0, y], plot.maxValues);
    setAttrs(animY, {
        attributeName: "y",
        begin: "indefinite",
        dur: "0.2",
        to: SVGCoordinates[1],
        fill: "freeze"
    });
    setAttrs(animHeight, {
        attributeName: "height",
        begin: "indefinite",
        dur: "0.2",
        to: SVGCoordinates[1]*(-1),
        fill: "freeze"
    });
    bar.appendChild(animHeight);
    bar.appendChild(animY);
    animHeight.beginElement();
    animY.beginElement();
    return bar
}


//Only for simple visulisation. 
function movedataRect(y, bar) {
    BarHeight = ((Math.log10(y))/Math.log10(100000)*90);
    if(BarHeight==-Infinity){BarHeight=-5;}
    //console.log(BarHeight);
    ycoord = 95-BarHeight;
    var animY= document.createElementNS(ns, "animate");
    var animHeight = document.createElementNS(ns, "animate");
    setAttrs(animY, {
        attributeName: "y",
        begin: "indefinite",
        dur: "0.1",
        to: ycoord+"%",
        fill: "freeze"
    });
    setAttrs(animHeight, {
        attributeName: "height",
        begin: "indefinite",
        dur: "0.1",
        to: "100%",
        fill: "freeze"
    });
    bar.appendChild(animHeight);
    bar.appendChild(animY);
    animHeight.beginElement();
    animY.beginElement();
    return bar
}



//Show Coordinates of the Point
function showCoordinates(point) {
    point.Coordinates = document.createElementNS(ns, "g");
    var Ctext = document.createElementNS(ns, "text");
    var banner = document.createElementNS(ns, "rect");
    var SVGCoordinates = scaleToSVG([point.xVal, point.yVal], point.parentElement.maxValues);
    setAttrs(Ctext, {
        y: SVGCoordinates[1],
        style: "font: 30px Calibri",
        "text-anchor": "front",
        "alignment-baseline": "Hanging"
    });
    setAttrs(banner, {
        x: SVGCoordinates[0] + 20,
        y: SVGCoordinates[1],
        width: "100",
        height: "80",
        fill: "rgba(255, 255, 255, 0.9)",
        rx: "15"
    });
    let XText = document.createElementNS(ns, "tspan");
    setAttrs(XText, {
        x: (SVGCoordinates[0] + 20),
        dy: "35px"
    });
    XText.textContent = document.getElementById("XLabelInput").value + ": " + parseFloat((point.xVal*dX).toPrecision(5)) + " ";
    Ctext.appendChild(XText);
    let YText = document.createElementNS(ns, "tspan");
    setAttrs(YText, {
        x: (SVGCoordinates[0] + 20),
        dy: "35px"
    });
    YText.textContent = document.getElementById("YLabelInput").value + ": " + point.yVal;
    Ctext.appendChild(YText);
    if (SVGCoordinates[0] + 120 >= point.parentElement.Width) {
        setAttrs(banner, { x: SVGCoordinates[0] - 120 });
        setAttrs(XText, { x: SVGCoordinates[0] - 120 });
        setAttrs(YText, { x: SVGCoordinates[0] - 120 });
    }
    point.Coordinates.appendChild(banner);
    point.Coordinates.appendChild(Ctext);
    point.parentElement.appendChild(point.Coordinates);
    if(!point.focused){
        changePointSize(point, CircSize * 2);
    }
}

//Hide shown Coordinates
function hideCoordinates(point) {
    point.parentElement.removeChild(point.Coordinates);
    if(!point.focused){
        changePointSize(point, CircSize);
    }
}
function switchFocus(point) {
    point.focused = !point.focused;
    if (point.focused){
        changePointSize(point, CircSize * 2);
        setAttrs(point, {
            fill: drawingColor,
            "stroke": "#5ee742a1",
            "stroke-width":"8"
        });
        point.TableEntry.className ="focused";
    }
    else {
        changePointSize(point, CircSize );
        setAttrs(point, {
            fill: drawingColor,
            "stroke": "#00000000",
            "stroke-width":"0"
        });
        point.TableEntry.className ="unfocused";
    }
}

function changePointSize(point, size) {
    animSize = document.createElementNS(ns, "animate");
    setAttrs(animSize, {
        attributeName: "r",
        begin: "indefinite",
        dur: "0.1",
        to: size,
        fill: "freeze"
    });
    point.appendChild(animSize);
    animSize.beginElement();
}


/************ Download Datapoints ********/

function DownloadCSV(Points, Header) {
    var csv_data = [];
    if (Points.length == 0) {
        alert("Es sind keine Messungen vorhanden,\n die heruntergeladen werden können.");
        return;
    }
    let d=new Date();
    let filename="Lichtstärkemessung "+d.getHours()+'.'+d.getMinutes()+'.'+d.getSeconds();
    filename=prompt("please enter filename:", filename);
    if (!filename){ return }
    var csv_columnTitle = Header;
    csv_data.push(csv_columnTitle.join(";"));
    console.log(csv_data);
    Points.forEach((element)=>csv_data.push(parseFloat((element.xVal*dX).toPrecision(5))+";"+element.yVal+";"+element.TimeStamp))
    csv_data = csv_data.join("\n");
    CSVFile = new Blob([csv_data], { type: "text/csv" });
    var temp_link = document.createElement('a');
    temp_link.download = filename+".csv";
    console.log(temp_link.download);
    var url = window.URL.createObjectURL(CSVFile);
    temp_link.href = url;
    // This link should not be displayed
    temp_link.style.display = "none";
    document.body.appendChild(temp_link);

    // Automatically click the link to trigger download
    temp_link.click();
    document.body.removeChild(temp_link);
}




/********* Only used within this script ************/

function createSVG(Ratio, Width, parent) {
    plot = document.createElementNS(ns, "svg");
    plot.Width = Width;
    plot.Height = parseInt(Math.floor(plot.Width * Ratio) * -1);
    var PlotViewBox = "-120 " + (plot.Height - 50) + " " + (plot.Width + 200) + " " + ((plot.Height * -1) + 150);
    setAttrs(plot, {
        xmlns: ns,
        style: "border: 0px solid rgb(0, 0, 0); background-color: #ffffff",
        class: "svg",
        viewBox: PlotViewBox,
    });
    document.getElementById(parent).appendChild(plot);
    return plot;
}

function getScalesteps(min, max, n) { //Berechnet aus dem kleinsten und dem größten Achsenwerte den Abstand und den ersten Wert.
    var Range = max - min;
    var factor = 1;
    while (Range / n / factor > 1) { factor *= 10; }
    while (Range / n / factor < 0.1) { factor /= 10; }
    var step = parseInt(Math.ceil(Range / n / factor)) * factor;
    if (Range / step <= n / 2) { step /= 2; }
    var firststep = parseInt(Math.ceil(min / step)) * step;
    return ([step, firststep]);
}
var setAttrs = (e, a) => Object.entries(a).forEach(([k, v]) => e.setAttribute(k, v));
var scaleToSVG = (xy, maxVs) => [plot.xFactor * xy[0] - maxVs[0] * plot.xFactor, plot.yFactor * xy[1] - maxVs[2] * plot.yFactor];  



)rawliteral";
/************************************************************************************************************************************************************************/
const char style_css[] PROGMEM = R"rawliteral(
/*------------- Allgemein -------------*/
:root{
    --graubackg:#eeeeee;
    --graubackg2:#bbbbbb;
    --grau:#333;
    --transparent:#66666600;
    --gruentransparent:#5ee742a1;

}
body {
    font-size: 120%;
    font-family: "Calibri Light", "Helvetica Neue", Arial, sans-serif;
    line-height:  1.4;
    color: var(--grau);
    background-color: #fff;
    margin: 0;
}

@media screen and (max-width: 850px) {
    body {
        font-size: 80%;
    }
}

/*------------- Header & Footer -------------*/
nav{
    width: 100vw;
    display:inline-block;
    padding:auto;
}

nav ul{
    margin: 0;
    list-style: none;
    background-color:var(--graubackg2);
    display: flex;
}
div ul{
    padding:0;
}
ul li{
    cursor: pointer;
    list-style: none;
    background-color:var(--graubackg2);

}ul li.placeholder{
    background-color:white;

}
header a{
    color: var(--grau);
    text-decoration: none;
    display: block;
    padding: 1.2rem;
    margin-left: 0.5rem;
    margin-right: 0.5rem;
    background-color: var(--graubackg2);
    cursor: pointer;
    border-radius: 0.3rem;
}


@media screen and (max-width: 850px) {
    header a{
        padding: 0.5rem;
    }
}

header a.open{
    font-weight: bold;
}
header a:hover{
    box-shadow: 0 0.2em 0.5em 0 rgba(0,0,0,0.24), 0 0.8em 1em 0 rgba(0,0,0,0.19);
}

footer{
    background-color:var(--graubackg2);
    color: var(--grau);
    padding: 0.1rem;
    margin-top: 0.1rem;
    padding-right:1.5rem;
    text-align: right;
    font-size: 100%;
}


/*------------- main -------------*/
main{
    max-width: 90rem;
    margin: auto;
    display: flex;
}

main.Block{
    display: Block;
}
h1 {
    font-size: 200%;
    font-weight: normal;
    text-decoration: underline; 
    text-align: center;
    padding: 1.5rem;
    margin: 0;
}
h2 {
    font-size: 130%;
    font-weight: normal;
    text-align: center;
    padding: 1.5rem;
    margin: 0;
}
details {
    background-color: #eeeeee;    
    border-radius: 0px 15px 0px 15px ;
    padding: 1.5rem;
    margin:0;
}
summary {
    font-size: 130%;
    font-weight: normal;
    text-align: left;
    padding-bottom: 0rem;
    margin: 0;
    cursor:pointer;
}
main ul{
    padding: 0px;
    margin: 0px;
    width: 100%;
}
main li{
    background-color: #ffffff;
    border: 2px solid var(--grau);
    border-radius: 8px;
    color: var(--grau);
    text-align: center;
    display: inline-block ;
    margin: 0.2rem;
    font-family: "Calibri";
    font-size: 2em;
    transition-duration: 0.4s;
    padding: 0.5rem;
    width: 100%;
    cursor: pointer;
    touch-action: manipulation;
    list-style: none;
}    
main li:hover{
    box-shadow: 0 12px 16px 0 rgba(0,0,0,0.24), 0 17px 50px 0 rgba(0,0,0,0.19);
}
main li.placeholder{
    box-shadow: 0 0 0 0 rgba(0,0,0,0.24), 0 0 0 0 rgba(0,0,0,0.19);
    cursor:default;
    border: 0px solid var(--grau);
}
.Button {
    background-color: #ffffff;
    border: 2px solid var(--grau);
    border-radius: 8px;
    color: var(--grau);
    justify-content: center;
    height:4rem;
    text-align: center;
    display: inline-block ;
    margin: 0.2rem;
    font-family: "Calibri";
    font-size: 1.2em;
    transition-duration: 0.4s;
    padding: 0.5rem;
    width: 100%;
    max-width: 16rem;
    cursor: pointer;
    touch-action: manipulation;
}
.Buttonlight {
    background-color: #ffffff;
    border: 1px solid var(--grau);
    border-radius: 15px;
    color: var(--grau);
    justify-content: center;
    height:3rem;
    text-align: center;
    display: inline-block ;
    margin: 0.2rem;
    font-family: "Calibri";
    font-size: 1em;
    transition-duration: 0.4s;
    padding: 0.5rem;
    width: 80%;
    min-width: 220px;
    max-width: 15rem;
    cursor: pointer;
    touch-action: manipulation;
}

.CharButton{
    background-color: #ffffff;
    border: 1px solid var(--grau);
    border-radius: 3px;
    color: var(--grau);
    justify-content: center;
    height:2rem;
    width: 2rem;
    text-align: center;
    display: inline-block ;
    margin: 0.2rem;
    font-family: "Cambria";
    font-size: 100%;
    transition-duration: 0.4s;
    cursor: pointer;
    touch-action: manipulation;
}

.Button:disabled {
    border: 1px solid #999;
    color: #999;
    font-weight: lighter;
    cursor: not-allowed;
}
.Buttonlight:disabled {
    border: 1px solid #999;
    color: #999;
    font-weight: lighter;
    cursor: not-allowed;
}

@media screen and (max-width: 850px) {
    .Button {
        height:3rem;
        max-width: 12rem;
    }
    .Buttonlight {
        height:2.5rem;
        min-width: 160px;
        max-width: 11rem;
    }
}


.Button:enabled:hover{
    background-color: #b5ffc8;
    box-shadow: 0 12px 16px 0 rgba(0,0,0,0.24), 0 17px 50px 0 rgba(0,0,0,0.19);
    font-weight: bold;

}
.Buttonlight:enabled:hover{
    background-color: #b5ffc8;
    box-shadow: 0 8px 12px 0 rgba(0,0,0,0.24), 0 10px 30px 0 rgba(0,0,0,0.19);
    font-weight: bold;

}



/*------------- grid -------------*/


.grid-container {
    max-width: 75rem;
    display: grid;
    margin: auto;
    grid-template-columns: 2% 32% 32% 32% 2%;
    padding: 0;
    text-align: center;
  }

.grid{
    padding: 0.5rem;
    margin: 0.5rem;
}
.gridplot {
    grid-area: 1/ 2/ 2 / 5;
    background-color: rgb(255, 255, 255);

}.gridplot2 {
    grid-area: 1/ 2/ 2 / 5;
    background-color: rgba(255, 255, 255, 0);

}

.gc1 {
    
    grid-area: 2 / 2/ span 1 / span 1;
}
.gc2 {
    grid-area: 2 / 3 / span 1 / span 1;
    padding-right: 0;
}
.gc3 {
    grid-area: 2 / 4 / span 1 / span 1;
    padding-left: 0;
    padding-top: 5%;
    padding-bottom: 5%;
}
.gc4 {
    grid-area: 3 / 2 / span 1 / span 1;
}
.gc5 {
    grid-area: 3 / 3 / span 1 / span 1;
}
.gc6 {
    grid-area: 3 / 4 / span 1 / span 1;
}
.gc7 {
    grid-area: 4 / 3 / span 1 / span 1;
}
.gridTable{
    
    grid-area: 5 / 2 / span 1 / span 3;
    padding: 0rem;
}

.gridback {
    padding: 0.5rem;
    margin: 0.5rem;
    
    background-color: #eeeeee;    
    border-radius: 0px 15px 0px 15px ;
}

.gb1 {
    grid-area: 2 / 3/ span 1/ span 2;
}
.gb2 {
    grid-area: 3 / 2/ span 1/ span 2;
}


@media screen and (max-width: 850px) {
    .grid-container {
        grid-template-columns: 20% 60% 20%;
      }
    .grid{
        padding: 0.7rem;
        margin: 0.4rem;
    }
    .gridplot {
        grid-area: 1 / 1 / span 1 / span 3;
    }
    .gc1 {
        grid-area: 2 / 2 / span 1 / span 1;
    }
    .gc2 {
        grid-area: 3 / 2 / span 1 / span 1;
        padding-bottom: 0;
    }
    .gc3 {
        grid-area: 4 / 2 / span 1 / span 1;
        padding-top: 0;
    }
    .gc4 {
        grid-area: 5 / 2 / span 1 / span 1;
        padding-bottom: 0;
    }
    .gc5 {
        grid-area: 6/ 2 / span 1 / span 1;
        padding-top: 0;
        padding-bottom: 0;
    }
    .gc6 {
        grid-area: 7 / 2 / span 1 / span 1;
        padding-top: 0;
        padding-bottom: 0;
    }
    .gc7 {
        grid-area: 8 / 2 / span 1 / span 1;
        padding-top: 0;
    }
    .gb1 {
        grid-area: 3 / 2/ span 2/ span 1;
    }   
    .gb2 {
        grid-area: 5 / 2/ span 4/ span 1;
    }
    .gridTable{
        grid-area: 9 / 1 / span 1 / span 3;
    }
}





/*------------- Input -------------*/

.inputField{
    font-size: 1em;
    font-family: "Calibri";
    text-align: center;
}


.inputField.label{
    width: 50%;
}

input[type=number]{
    font-size: 1em;
    width: 2.5em;
    border:none;
    box-shadow: 0 2px 3px 0 rgba(0,0,0,0.24), 0 2px 3px 0 rgba(0,0,0,0.19);
    background-color:#ffffff;
    color:var(--grau);
}

input[type=number]:enabled:hover{
    box-shadow: 0 12px 16px 0 rgba(0,0,0,0.24), 0 17px 50px 0 rgba(0,0,0,0.19);
}
input[type=number]:disabled{
    color: #b6b6b6;
    box-shadow: none;
}
input[type=number]:focus{
    border:0px solid var(--grau);
    border-radius: 0px;
    box-shadow: 0 12px 16px 0 rgba(0,0,0,0.24), 0 17px 50px 0 rgba(0,0,0,0.19);
}



/*------------- Table -------------*/


table {
    border-collapse: collapse;
    width: 100%;
    max-width: 60rem;
    margin: 20px auto;
}
th,
td {
    padding: 10px;
    border: 1px solid #ffffff;
    
    text-align: left;
    width: 25%;
}
th {
    background-color: #fff;
}
tr{
    border: 1px solid #fff;
    font-weight: normal;
}
tr.focused{
    border: 3px solid var(--gruentransparent);
    font-weight: bold;
}
td {
    cursor: pointer;
}

/*------------------Naiv.Display----------*/


.DataVis {
    position: fixed; /* Stay in place */
    z-index: 1; /* Sit on top */
    left: 0;
    top: 3rem;
    width: 100%; /* Full width */
    height: 100%; /* Full height */
    overflow: auto; /* Enable scroll if needed */
  }
@media screen and (max-width: 850px) {
    .DataVis {
        top: 1.5rem;
    }
}

.plot {
    max-width:101rem;
    height: calc(100vh - 15rem);
    margin:0 auto;
}
@media screen and (max-width: 850px) {
    .plot {
        height: calc(100vh - 12rem);
        margin:0 auto;
    }
}


/*.Displaystuff{  
    position: relative;
    background-color: #ffffffee;
    margin: auto;
    margin-top: 60px;
    padding: 0;
    border: 0px solid var(--grau);
    width: 60%;
    max-width: 800px;
    min-width: 280px;
    height: auto;
    box-shadow: 0 4px 8px 0 rgba(0,0,0,0.2),0 6px 20px 0 rgba(0,0,0,0.19);
    border-radius: 10px;
}
*/
/*------------------popup----------*/


.popupBackground {
    display: none; /* Hidden by default */
    position: fixed; /* Stay in place */
    z-index: 1; /* Sit on top */
    left: 0;
    top: 0;
    width: 100%; /* Full width */
    height: 100%; /* Full height */
    overflow: auto; /* Enable scroll if needed */
    background-color: rgb(0,0,0); /* Fallback color */
    background-color: rgba(0,0,0,0.2); /* Black w/ opacity */
    font-family: "Calibri Light", "Helvetica Neue", Arial, sans-serif;
  }
.popup{  
    position: relative;
    background-color: #ffffffee;
    margin: auto;
    margin-top: 60px;
    padding: 0;
    border: 0px solid var(--grau);
    width: 60%;
    max-width: 800px;
    min-width: 280px;
    height: auto;
    box-shadow: 0 4px 8px 0 rgba(0,0,0,0.2),0 6px 20px 0 rgba(0,0,0,0.19);
    border-radius: 10px;
}

.popup div{
    padding: 1rem;
}

.popup h2 {
    color: var(--grau);
    background-color: var(--graubackg2);
    font-size: 130%;
    font-weight: bolder;
    text-align: left;
    padding: 0.5rem;
    padding-left:1rem;
    border: 0px solid var(--grau);
    /*box-shadow: 0 4px 8px 0 rgba(0,0,0,0.2),0 6px 20px 0 rgba(0,0,0,0.19);*/
    border-radius: 8px
}

@media screen and (max-width: 850px) {
    .popup h2{  
        font-size: 195%;
    }
}

.popup h3 {
    font-size: 120%;
    text-align: left;
    margin: 0;
}

.popup .inputField{
    text-align: left;
    
}

.popup input[type="text"]{
    width:4.5em;
    font-size: 1em;
    font-family: "Cambria";
    border:none;
    box-shadow: 0 2px 3px 0 rgba(0,0,0,0.24), 0 2px 3px 0 rgba(0,0,0,0.19);
    background-color:#ffffff;
    color:var(--grau);
}
.popup input:hover[type="text"]{
    width:4.5em;
    font-size: 1em;
    border:none;
    box-shadow: 0 2px 3px 0 rgba(0,0,0,0.24), 0 2px 3px 0 rgba(0,0,0,0.19);
    background-color:#eeeeee;
    color:var(--grau);
    
}.popup input:focus[type="text"]{
    width:4.5em;
    font-size: 1em;
    border:none;
    box-shadow: 0 2px 3px 0 rgba(0,0,0,0.24), 0 2px 3px 0 rgba(0,0,0,0.19);
    background-color:#eeeeee;
    color:var(--grau);
}

.popup .Closebutton{
    position: absolute;
    display: inline-block;
    right: 0; 
    top: 0;
    font: 1rem sans-serif;
    font-weight: bolder;
    height:1.3rem;
    width: 1.3rem;
    padding: 15px;
    text-align: center;
    cursor: pointer;
    border-radius: 8px;

}
.Closebutton:hover{
    background-color: #86000098;
}
)rawliteral";
